#pragma once

#include "task_setup.h"

#include <saas/rtyserver_jupi/library/extbuilder/wad_merge.h>
#include <saas/rtyserver_jupi/library/extbuilder/arc_merge.h>
#include <saas/rtyserver_jupi/library/extbuilder/timer_wrapper.h>
#include <saas/rtyserver_jupi/library/rtyt/util.h>
#include <saas/rtyserver_jupi/library/rtyt/docid_mapper.h>
#include <mapreduce/yt/library/cypress_path/cypress_path.h>


namespace NFusion {

class TBuilder {
    THolder<TTimerLog> TimerLog;
    TRTYTTaskSetup TaskSetup;
    
    void RunReducers();
    void ExecuteBuilderCmd(const TString& processorName,
                    const std::function<void(NJupiter::TProcArgs&)>& command);
    void RunBuildAndMerge();

    void RunRemap(NJupiter::TTableBase* table, const ::google::protobuf::Descriptor* descriptor, const TString& srcName, const TVector<ui32>& mapping);
    
    void RunDocIdRemappings();

public:
    void BuildIndex();
    
    TBuilder(TRTYTTaskSetup&& setup, const TMaybe<TFsPath>& timerLogPath, const TString& realm)
        : TaskSetup(std::move(setup))
        {
        if (timerLogPath.Defined()) {
            TimerLog = MakeHolder<TTimerLog>(timerLogPath.GetRef().GetPath(), realm, TaskSetup.GetOutput().GetName());
        } else {
            TimerLog = MakeHolder<TTimerLog>(MakeHolder<TNullLogBackend>(), realm, TaskSetup.GetOutput().GetName());
        }
    }
};

} // namespace NFusion
