#include "task_setup.h"

#include <robot/jupiter/library/opt/mropt.h>

namespace NFusion {

TIntrusivePtr<NRTYT::TClient> TRTYTTaskSetup::GetClientPtr() const {
    return ClientPtr;
}

NJupiter::TCommonOpts TRTYTTaskSetup::GetCommonOpts(const TString& processorName, const TFsPath& inputPath) const {
    Y_UNUSED(processorName);
    NJupiter::TCommonOpts result;
    result.MrPrefix = "//tmp/" + inputPath.Basename();
    result.CurrentState = "";
    result.BucketNumber = 0;
    result.BucketsCount = 1;
    result.DataPath = ""; // no models
    return result;
}

NJupiter::TArcMergeOpts TRTYTTaskSetup::GetArcMergeOpts() const {
    NJupiter::TArcMergeOpts result;
    result.DocsCount = Max<ui32>();
    result.EnableBertEmbeddings = true;
    return result;
}

NJupiter::TShardMergerOpts TRTYTTaskSetup::GetShardMergerOpts(const TString& processorName, const TFsPath& inputPath) const {
    if (!ProcessorIdByName.contains(processorName)) {
        ythrow yexception() << "[GetShardMergerOpts] unknown processor name: " << processorName;
    }
    int processorId = ProcessorIdByName.find(processorName)->second;
    auto processorParams = BuilderParams.GetOperations().GetOperation(processorId);
    NJupiter::TShardMergerOpts opts;
    opts.OutputDir = inputPath; // where to store delta wads. It's not so intuitive
    opts.TmpDir = TempDir;
    opts.StatsDir = TempDir;

    opts.FilePrefix = processorParams.GetFilePrefix();
    return opts;
}

NJupiter::TProcArgs TRTYTTaskSetup::GetArgsBundle(const TString& processorName, const TFsPath& inputPath) const {
    NJupiter::TProcArgs result(
            GetClientPtr(),
            GetCommonOpts(processorName, inputPath),
            GetShardMergerOpts(processorName, inputPath),
            GetArcMergeOpts()
    );
    result.IsExtInfoArcPudged = false;
    result.UseRecoverableCmd = false;
    result.ExtInfoArcWriteKeys = false;
    return result;
}

const TRTYTBuilderConfig::TBuildOperation& TRTYTTaskSetup::GetBuildOperationParams(const TString& processorName) const {
    if (!ProcessorIdByName.contains(processorName)) {
        ythrow yexception() << "[GetShardMergerOpts] unknown processor name: " << processorName;
    }
    int processorId = ProcessorIdByName.find(processorName)->second;
    return BuilderParams.GetOperations().GetOperation(processorId);
}

}
