#include "util.h"

#include <library/cpp/logger/global/global.h>

TVector<ui32> ReadDocIdsFromRtyt(NYT::IClientBasePtr client, const TString& ytPath) {
    size_t tableSize = client->Get(ytPath).ChildAsUint64("row_count");
    TVector<ui32> docidMap(tableSize, NRtDoc::TDocIdMap::DeletedDocument());
    auto reader = client->CreateTableReader<NYT::TNode>(ytPath);
    for (; reader->IsValid(); reader->Next()) {
        auto row = reader->GetRow();
        ui32 oldId = row.ChildAsUint64("old");
        ui32 newId = row.ChildAsUint64("new");
        if (oldId >= tableSize) {
            DEBUG_LOG << "get invalid docid on position " << reader->GetRowIndex() << ", docid = " << oldId << Endl;
        } else {
            docidMap[oldId] = newId;
        }
    }
    return docidMap;
}

TString FormatRTYTMergeMapPath(const TString& tempDir, const TFsPath& srcDir) {
    return "//" + TFsPath(tempDir).Basename() + "/" + srcDir.Basename();
}

bool IsPrepIndex(const TFsPath& indexPath) {
    return indexPath.Basename().StartsWith("prep");
}
