#include "tables.h"

namespace NFusion {

// If you're editing set of processors, check out rtyserver_jupi/library/extbuilder/portions_bundle.cpp -- maybe it also needs in your fix
THashMap<TString, const NProtoBuf::Descriptor*> GetPrepTableTypes() {
    const auto tables = NJupiter::TShardsPrepareTables::Clientless();

    #define MAP_ITEM(get) \
        {NJupiter::GetYtPathName(tables.get), decltype(tables.get)::TProto::descriptor()}

    THashMap<TString, const NProtoBuf::Descriptor*> prepTypes {
        MAP_ITEM(GetWalrusWithKeyInvDocChunkMappingSingleChunkTable(0)),
        MAP_ITEM(GetWalrusTable(0)),
        MAP_ITEM(GetCalculatedAttrsWithKeyInvDocChunkMappingSingleChunkTable(0)),
        MAP_ITEM(GetExternalRelevAttrsTable(0)),
        MAP_ITEM(GetHostAttrsTable(0)),
        MAP_ITEM(GetErfHerfFeaturesTable(0)),
        MAP_ITEM(GetKeyInvCountsTable(0)),
        MAP_ITEM(GetAnnCountsTable(0)),
        MAP_ITEM(GetLinkAnnCountsTable(0)),
        MAP_ITEM(GetFactorAnnCountsTable(0)),
        MAP_ITEM(GetMetaTagsCountsTable(0)),
        MAP_ITEM(GetNgramCountsTable(0)),
        MAP_ITEM(GetAttrsKeyInvTable(0)),
        MAP_ITEM(GetCountsKeyInvTable(0)),
        MAP_ITEM(GetPantherDssmTermsTable(0)),
        MAP_ITEM(GetPantherDssmUrlTitleEmbeddingsTable(0)),
        MAP_ITEM(GetStatsTableLink()),
        MAP_ITEM(GetCalculatedAttrsTable(0)),
        MAP_ITEM(GetContentAttrsTable(0)),
        MAP_ITEM(GetUrlHeavyDataTable(0)),
        MAP_ITEM(GetGroupAttrsConfigTable(0)),
        MAP_ITEM(GetNavSrcStrictTable(0)),
        MAP_ITEM(GetHostMappingTable(0)),
        MAP_ITEM(GetHostDomainDocMappingsTable(0)),
        MAP_ITEM(GetMobileUrlTable(0)),
    };

#undef MAP_ITEM

    return prepTypes;
}

THashMap<TString, const NProtoBuf::Descriptor*> GetRTYTPrepTableTypes() {
    const auto tables = NJupiter::TShardsPrepareTables::Clientless();

    #define MAP_ITEM(get) \
        {NJupiter::GetYtPathName(tables.get), decltype(tables.get)::TProto::descriptor()}

    THashMap<TString, const NProtoBuf::Descriptor*> prepTypes {
        MAP_ITEM(GetWalrusTable(0)),
        MAP_ITEM(GetExternalRelevAttrsTable(0)),
        MAP_ITEM(GetCalculatedAttrsTable(0)),
        MAP_ITEM(GetContentAttrsTable(0)),
        MAP_ITEM(GetUrlHeavyDataTable(0)),
        MAP_ITEM(GetMobileUrlTable(0))
    };

#undef MAP_ITEM

    return prepTypes;
}

}
