#pragma once

#include <kernel/doom/key/decoded_key.h>
#include <kernel/doom/hits/reqbundle_hit.h>

#include <util/generic/vector.h>
#include <util/stream/str.h>

namespace {
    using namespace NDoom;

    class TSegment {
    };

    class TTestData {
        TVector<TSegment> Segments;
    };

    struct TGlobalItem {
        TDecodedKey Key;
        TVector<TReqBundleHit> Hits;

        TGlobalItem() = default;
        TGlobalItem(const TStringBuf& lemma) {
            Key.SetLemma(lemma);
        }

        TGlobalItem& AddForm(const TStringBuf& text) {
            Key.AddForm(ELanguage::LANG_ENG, FORM_HAS_LANG, text);
            return *this;
        }

        TGlobalItem& SetHits(const TVector<TReqBundleHit>& data) {
            Hits = data;
            return *this;
        }
    };
}
