#include <saas/rtyserver_jupi/tools/arc2wad/params.pb.h>

#include <saas/rtyserver_jupi/library/extbuilder/arc_merge.h>

#include <kernel/doom/wad/wad_lump_id.h>

#include <library/cpp/getoptpb/getoptpb.h>

int main(int argc, const char* argv[]) {
    NGetoptPb::TGetoptPbSettings getoptSettings;
    getoptSettings.DumpConfig = false;
    NUtils::TParams params = NGetoptPb::GetoptPbOrAbort(argc, argv, getoptSettings);

    NDoom::TWadLumpId lumpId;
    switch (params.GetType()) {
        case NUtils::ExtInfo:
            lumpId = NDoom::TWadLumpId(NDoom::EWadIndexType::ExtInfoArcIndexType, NDoom::EWadLumpRole::Struct);
            break;
        case NUtils::LinkAnn:
            lumpId = NDoom::TWadLumpId(NDoom::EWadIndexType::LinkAnnArcIndexType, NDoom::EWadLumpRole::Struct);
            break;
        case NUtils::Arc:
            lumpId = NDoom::TWadLumpId(NDoom::EWadIndexType::ArcIndexType, NDoom::EWadLumpRole::Struct);
            break;
        default:
            Y_ENSURE(false, "unknown archive type");
    }

    NRtDoc::ConvertArcToWad(params.GetIn(), params.GetOut(), lumpId);

    return 0;
}

