#include <saas/rtyserver_jupi/tools/dump_keyinv_wad/params.pb.h>
#include <saas/rtyserver_test/util/oxy/docid_restore.h>
#include <saas/rtyserver_test/util/oxy/ki_dumpers.h>

#include <library/cpp/getoptpb/getoptpb.h>

#include <util/folder/path.h>

int main(int argc, const char* argv[]) {
    NGetoptPb::TGetoptPbSettings getoptSettings;
    getoptSettings.DumpConfig = false;
    NUtils::TParams params = NGetoptPb::GetoptPbOrAbort(argc, argv, getoptSettings);
    auto docUrls = NSaas::LoadDocUrls(params.GetSegment());
    auto lines = TRTYKeyInvDumper::DumpKeyInvFromWad(JoinFsPaths(params.GetSegment(), params.GetIndex()), docUrls.Get(), params.GetSkipTermId());
    for (auto& line : lines) {
        Cout << line << '\n';
    }
    return 0;
}

