#include <search/meta/searcherprops/factory.h>
#include <search/meta/searcherprops/rules.h>

class TCollectBySourceOrPassThroughRule: public TCollectBySourceRule {
protected:
    void Flush(const TString& key, TPropertyContainer& props) override {
        if (ValueBySource_.size() == 1) {
            const TString& value = ValueBySource_.begin()->second;
            props.SetProperty(key, value);
        } else {
            TCollectBySourceRule::Flush(key, props);
        }
    }
};

TAggregationRuleFactory::TRegistrator<TCollectBySourceRule> RTYRequest("rty_request");

TAggregationRuleFactory::TRegistrator<TCollectBySourceOrPassThroughRule> MisspellFixed("MisspellFixed");
TAggregationRuleFactory::TRegistrator<TCollectBySourceOrPassThroughRule> MisspellRule("MisspellRule");
TAggregationRuleFactory::TRegistrator<TCollectBySourceOrPassThroughRule> MisspellSrcText("MisspellSrcText");
TAggregationRuleFactory::TRegistrator<TCollectBySourceOrPassThroughRule> MisspellRel("MisspellRel");
TAggregationRuleFactory::TRegistrator<TCollectBySourceOrPassThroughRule> MisspellCode("MisspellCode");
TAggregationRuleFactory::TRegistrator<TCollectBySourceOrPassThroughRule> MisspellApplied("MisspellApplied");

// for Fusion rearrange rule
TAggregationRuleFactory::TRegistrator<TSumRule<ui64>> FusionRealtimeDocCount("Fusion.RealtimeDocCount");
TAggregationRuleFactory::TRegistrator<TSumRule<ui64>> FusionQuickDocCount("Fusion.QuickDocCount");
TAggregationRuleFactory::TRegistrator<TSumRule<ui64>> FusionFreshRealtimeDocCount("Fusion.FreshRealtimeDocCount");
TAggregationRuleFactory::TRegistrator<TSumRule<ui64>> FusionFreshQuickDocCount("Fusion.FreshQuickDocCount");
