#include "auth.h"

#include <saas/library/searchserver/replier.h>
#include <saas/searchproxy/search_meta/extendedcontext.h>
#include <saas/searchproxy/logging/access_log.h>
#include <saas/searchproxy/unistat_signals/signals.h>

namespace NSearchProxy {

    void LogAccessDenied(const NSaas::TNotAuthorizedInfo& auth, const TString& proxyType, IReplyContext& context) {
        TExtendedReplyContext erc(&context);
        if (proxyType) {
            erc.SetMetaSearchType(proxyType);
        }
        erc.SetHttpStatus(auth.HttpCode);
        NSearchProxy::NLogging::TInfoLog::Log(context.GetRequestId(), erc);
    }

}
