#include "cgi.h"
#include <util/string/split.h>

namespace NSearchProxyCgi {
    TString GetL3FormulaName(const TCgiParameters& cgi) {
        for (const auto& relev: cgi.Range("relev")) {
            for (const auto& i: StringSplitter(relev).Split(';').SkipEmpty()) {
                const TStringBuf token = i.Token();
                TStringBuf key;
                TStringBuf value;
                if (!token.TrySplit('=', key, value)) {
                    continue;
                }
                if (key == "l3_formula") {
                    return TString{value};
                }
            }
        }
        return {};
    }
} // namespace NSearchProxyCgi
