#pragma once

#include <library/cpp/cgiparam/cgiparam.h>
#include <util/generic/string.h>

namespace NSearchProxyCgi {
    const TString broadcast("/broadcast/");
    const TString global_ping("/global_ping/");

    const TString service("service");
    const TString metaservice("metaservice");
    const TString complete("complete");
    const TString g("g");
    const TString p("p");
    const TString gta("gta");
    const TString kps("kps");
    const TString text("text");
    const TString tmplate("template");
    const TString userId("user_id");
    const TString auth("auth");
    const TString uid("uuid");
    const TString fake_uid("fake_uuid");
    const TString yandexuid("yandexuid");
    const TString queryid("reqid");
    const TString raid("raId");
    const TString how("how");
    const TString ip("client-ip");
    const TString suggest_part("part");
    const TString ya_service_ticket("ya_service_ticket");
    const TString ya_user_ticket("ya_user_ticket");
    const TString force_tvm_auth("force_tvm_auth");

    const TString test_buckets("test_buckets");
    const TString robot("robot");
    const TString region("lr");
    const TString parentReqid("parent-reqid");

    struct TClickLogField {
    public:
        TString CgiParam;
        TString Remap;
        bool Escape;

    public:
        TClickLogField(const TString& param)
            : CgiParam(param)
            , Remap(param)
            , Escape(true)
        {}
        TClickLogField(const TString& param, const TString& remap)
            : CgiParam(param)
            , Remap(remap)
            , Escape(true)
        {}
        TClickLogField(const TString& param, const TString& remap, bool escape)
            : CgiParam(param)
            , Remap(remap)
            , Escape(escape)
        {}
    public:
        bool operator<(const TClickLogField& o) const {
            return CgiParam < o.CgiParam;
        }
    };

    const TString HashParams[] = {
        text,
        tmplate,
        kps
    };

    const TClickLogField ClickLogging[] = {
        TClickLogField(service),
        TClickLogField(kps),
        TClickLogField(uid, "uid"),
        TClickLogField(yandexuid),
        TClickLogField(queryid, "reqid"),
        TClickLogField(raid),
        TClickLogField(test_buckets, "slots", false),
        TClickLogField(how),
        TClickLogField(fake_uid, "fake-uid")
    };

    TString GetL3FormulaName(const TCgiParameters& cgi);
}
