#pragma once

#include <saas/library/daemon_base/daemon/messages.h>

#include <util/generic/set.h>

namespace NSearchProxy {
    using THostSet = TSet<TString>;
}

class TCollectSearchProxyServerInfo: public TCollectServerInfo {
public:
    struct TSearchQueueState {
        size_t MainQueueSize = 0;
        size_t FetchQueueSize = 0;
    };

    using TSearchQueues = TMap<TString, TSearchQueueState>;

public:
    NSearchProxy::THostSet UnresolvedHosts;
    TMap<TString, TString> IncorrectServices;
    TSearchQueues SearchQueues;

public:
    using TCollectServerInfo::TCollectServerInfo;

    virtual void Fill(TServerInfo& info) {
        TCollectServerInfo::Fill(info);
        {
            NJson::TJsonValue hosts;
            for (auto&& host : UnresolvedHosts) {
                hosts.AppendValue(host);
            }
            info("unresolved_hosts", hosts);
            info("unresolved_count", UnresolvedHosts.size());
        }
        {
            NJson::TJsonValue errorServices;
            for (auto&& is : IncorrectServices) {
                errorServices.InsertValue(is.first, is.second);
            }
            info("error_services", errorServices);
        }
        {
            NJson::TJsonValue searchers;
            for (auto&& i : SearchQueues) {
                NJson::TJsonValue searcher;
                searcher.InsertValue("main", i.second.MainQueueSize);
                searcher.InsertValue("fetch", i.second.FetchQueueSize);
                searchers.InsertValue(i.first, searcher);
            }
            info("search_queues", searchers);
        }
    }
};
