#include "misspellcorrectorconfig.h"

#include <saas/library/daemon_base/config/daemon_config.h>

#include <library/cpp/cgiparam/cgiparam.h>

#include <util/generic/ptr.h>

const TString TMisspellCorrectorConfig::DefaultRawResposeOptions = "fix=1";

TMisspellCorrectorConfig::TMisspellCorrectorConfig(
    const TYandexConfig::Directives& directives)
    : EnablePorno(directives.Value("EnablePorno", false))
    , Log(directives.Value("Log", TString()))
{
    const auto connectionTimeout = TDuration::MilliSeconds(30);
    const auto interactionTimetout = TDuration::MilliSeconds(150);
    Connection = TDaemonConfig::ParseConnection(directives, {}, connectionTimeout, interactionTimetout);
    RawResposeOptions = directives.Value("RawResposeOptions", DefaultRawResposeOptions);
    if (RawResposeOptions == "EMPTY")
        RawResposeOptions.clear();

    TCgiParameters cgi(directives.Value("CgiParameters", TString()));
    cgi.InsertUnescaped("fix", "1");
    CgiParametersStr = cgi.Print();
    Service = cgi.Get("srv");
    if (Service.empty()) {
        Service = "saas";
    }
}

TMisspellCorrectorConfig::TMisspellCorrectorConfig()
    : EnablePorno(false)
{}
