#pragma once

#include "misspellcorrectorconfig.h"

#include <search/config/virthost.h>

#include <library/cpp/yconf/conf.h>
#include <library/cpp/charset/ci_string.h>

#include <util/generic/ptr.h>
#include <util/folder/dirut.h>

class TSearchServerConfig: public TSearchConfig {
private:
    const TString CurrentFolder = NFs::CurrentWorkingDirectory() + GetDirectorySeparator();
    TYandexConfig::TSectionsMap Sections;

private:
    void ParseDirectives(const TYandexConfig::Directives& directives);
    void ParseWizardConfig();
    void ParseMisspell();

public:
    TCopyPtr<TMisspellCorrectorConfig> MisspellCorrectorConfig;
    TCiString TemplateCorrectionPolicy = "no";
    bool ClicksLogging = false;
    bool SafeReport = false;
    bool MetaService = false;

public:
    // set default values
    TSearchServerConfig();

    void AdjustForMetaService();
    void InitFromSection(TYandexConfig::Section* section, TConfigPatcher& preprocessor);
    void SetWorkDir(const TString& workDir);
};
