#include "controller.h"

TSearchProxyController::TSearchProxyController(TServerConfigConstructorParams& params, const TController::IServerDescriptor& sd)
    : TController(params, sd)
{
}

TSearchProxyController::TSPControllerClient::TSPControllerClient(TController& owner)
    : TController::TClient(owner)
{}

void TSearchProxyController::TSPControllerClient::ProcessServerStatus() {
    NController::TSlotStatus dataStatus = Owner.GetServerDataStatus();
    const TString origin{GetBaseRequestData().HeaderInOrEmpty("Origin")};
    const TString originHeader(!!origin ? ("Access-Control-Allow-Origin:" + origin + "\r\nAccess-Control-Allow-Credentials:true\r\n") : TString());
    Output() << "HTTP/1.1 200 Ok\r\n"sv
        << originHeader
        << "Content-Type: text/plain\r\n\r\n"sv
        << "ControllerStatus          : " << ToString(Owner.GetStatus()) << '\n'
        << "ServerDataStatus          : " << NController::TSlotStatus_Name(dataStatus) << '\n'
        << "IsServerDataStatus_OK          : " << ((NController::TSlotStatus::OK == dataStatus) ? '1' : '0');
}
