#pragma once

#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <util/datetime/base.h>

namespace NSearchProxy {

    class IAbcResolver {
    public:
        using TUid = ui64;
        using TAbcId = ui32;

        virtual ~IAbcResolver() {
        }

        virtual void Start() {
        }

        virtual void Stop() {
        }

        virtual TVector<TUid> Resolve(const TVector<TAbcId>& abcGroups) const = 0;
    };

    class TAbcResolver: public IAbcResolver {
    public:
        using TTvmClientPtr = TAtomicSharedPtr<NTvmAuth::TTvmClient>;

        struct TParams {
            TString ApiUrl = "https://abc-back.yandex-team.ru";
            ui32 ApiTvmId{};
            TVector<TAbcId> GroupsToResolve;
            TTvmClientPtr TvmClient;
            TDuration UpdatePeriod = TDuration::Hours(1);
            TString CacheDir;
            size_t MaxErrorCountPerUpdate = 3;
            struct TFetchConfig {
                TDuration Timeout = TDuration::Seconds(30);
                TDuration ConnectTimeout = TDuration::Seconds(5);
                ui32 RetryCount = 2;
                TDuration RetryDelay = TDuration::Seconds(5);
            } FetchConfig;
        };

        TAbcResolver(const TParams& params);
        ~TAbcResolver();

        void Start() override;
        void Stop() override;

        TVector<TUid> Resolve(const TVector<TAbcId>& abcGroups) const override;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
