#include "searchproxyserver.h"

#include <saas/library/daemon_base/daemon/controller.h>
#include <saas/searchproxy/common/messages.h>

DEFINE_CONTROLLER_COMMAND(TSearchProxyServer, enable_eventlog, "arguments: service")
    const TString& service = GetCgi().Get("service");
    const auto& message = SendGlobalMessage<NSearchProxy::TControlEventLogMessage>(service, /*targetState=*/true);
    if (!message.TargetServiceFound) {
        Write("error", "service not found");
    }
    Write("enabled", message.ResultState);
END_CONTROLLER_COMMAND

DEFINE_CONTROLLER_COMMAND(TSearchProxyServer, disable_eventlog, "arguments: service")
    const TString& service = GetCgi().Get("service");
    const auto& message = SendGlobalMessage<NSearchProxy::TControlEventLogMessage>(service, /*targetState=*/false);
    if (!message.TargetServiceFound) {
        Write("error", "service not found");
    }
    Write("enabled", message.ResultState);
END_CONTROLLER_COMMAND
