#pragma once

#include <saas/library/searchserver/exception.h>
#include <saas/searchproxy/common/cgi.h>

#include <library/cpp/http/misc/httpcodes.h>


class TServiceNameExtractor {
public:
    static TString ExtractServiceName(const TCgiParameters& cgi);
};


TString TServiceNameExtractor::ExtractServiceName(const TCgiParameters& cgi) {
    const size_t cgiCount = cgi.NumOfValues(NSearchProxyCgi::service);

    if (cgiCount > 1) {
        throw TSearchException(HTTP_BAD_REQUEST, yxINCOMPATIBLE_REQ_PARAMS) << "More than one 'service' cgi parameters are present";
    }

    return cgi.Get(NSearchProxyCgi::service);
}
