#pragma once

#include "fields.h"

#include <library/cpp/logger/global/rty_formater.h>
#include <saas/util/logging/tskv_log.h>

#include <util/generic/string.h>
#include <library/cpp/cgiparam/cgiparam.h>

class ISearchContext;
class TPassageContext;
class TSearchRequestData;

struct TPassageRequestInfo {
    const TPassageContext& Context;
    const TSearchRequestData& RD;
};

namespace NSearchProxy {
    class TExtendedContextBase;
}
class TExtendedReplyContext;
class TExtendedSearchContext;

TString EscapeStat(const TStringBuf& s);

TString GetUserRequest(const TCgiParameters& cgi);
TString GetKeyPrefix(const TCgiParameters& cgi);
TString GetFullCgiParameter(const TCgiParameters& cgi, const TString& name, const char* separator);

ui64 GetRequestDuration(ISearchContext* searchContext);
ui64 GetRequestDuration(TPassageRequestInfo passageInfo);
ui64 GetRequestDuration(const TSearchRequestData& rd);

ui64 GetReportDuration(const NSearchProxy::TExtendedContextBase& context);
ui64 GetWaitInQueueDuration(const TExtendedReplyContext& context);
ui64 GetWaitInQueueDuration(const TExtendedSearchContext& context);

void InsertQueryInfo(NUtil::TTSKVRecord& record, const TCgiParameters& cgi, const TSearchRequestData& rd);
void InsertClientIp(NUtil::TTSKVRecord& record, const TSearchRequestData& rd);
void InsertIncomingInfo(NUtil::TTSKVRecord& record, const TSearchRequestData& rd);
