#include "common.h"
#include "error_log.h"

using namespace NSearchProxy::NLogging;

void TErrorLog::Log(ui32 id, const TSearchRequestData& rd, const TString& errorMessage) {
    if (!TLoggerOperator<TErrorLog>::Usage())
        return;

    NUtil::TTSKVRecord record("saas-error");

    record.Add(HrTimeLable, Now().ToString());
    record.Add(IdLable, id);
    InsertIncomingInfo(record, rd);
    record.Add(ReplyTimeLable, GetRequestDuration(rd));
    record.Add(ErrorLable, errorMessage);

    TLoggerOperator<TErrorLog>::Log() << record.ToString() << Endl;
}
