#include "common.h"
#include "incoming_log.h"

#include <search/session/reqenv.h>
#include <search/request/data/reqdata.h>

#include <kernel/search_daemon_iface/cntintrf.h>

#include <util/system/thread.h>

using namespace NSearchProxy::NLogging;

namespace {
    void LogIncoming(ui32 id, const TStringBuf type, const TSearchRequestData& rd) {
        if (!TLoggerOperator<TIncomingLog>::Usage())
            return;
        NUtil::TTSKVRecord record("saas-incoming");

        record.Add(IdLable, id);
        record.Add(HrTimeLable, Now().ToString());
        record.Add(RequestTypeLable, type);
        InsertIncomingInfo(record, rd);

        TLoggerOperator<TIncomingLog>::Log() << record.ToString() << Endl;
    }
}

void NSearchProxy::NLogging::TIncomingLog::Log(ui32 id, ISearchContext* searchContext) {
    TReqEnv* reqEnv = static_cast<TReqEnv*>(searchContext->ReqEnv());
    ::LogIncoming(id, "search", *reqEnv->RequestData);
}

void NSearchProxy::NLogging::TIncomingLog::Log(ui32 id, const IReplyContext& context) {
    ::LogIncoming(id, "search", context.GetRequestData());
}

void NSearchProxy::NLogging::TIncomingLog::Log(ui32 id, const TPassageRequestInfo& passageInfo) {
    ::LogIncoming(id, "fetch", passageInfo.RD);
}
