#include "loggerconfig.h"

#include <util/folder/dirut.h>
#include <util/generic/string.h>

#include "incoming_log.h"
#include "access_log.h"
#include "error_log.h"
#include "fetch_log.h"
#include "reqans_log.h"
#include "tvm_log.h"
#include "misspell_log.h"

using namespace NSearchProxy::NLogging;

TLoggerConfig::TLoggerConfig(const TYandexConfig::Directives& directives,
    const TString& workDir, const TDaemonConfig& config)
{
    if (directives.GetValue("IncomingLog", IncomingLog)) {
        resolvepath(IncomingLog, workDir);
        config.StartLoggingUnfiltered<TIncomingLog>(IncomingLog);
    }

    if (directives.GetValue("InfoLog", InfoLog)) {
        resolvepath(InfoLog, workDir);
        config.StartLoggingUnfiltered<TInfoLog>(InfoLog);
    }

    if (directives.GetValue("ErrorLog", ErrorLog)) {
        resolvepath(ErrorLog, workDir);
        config.StartLoggingUnfiltered<TErrorLog>(ErrorLog);
    }

    if (directives.GetValue("FetchLog", FetchLog)) {
        resolvepath(FetchLog, workDir);
        config.StartLoggingUnfiltered<TFetchLog>(FetchLog);
    }

    if (directives.GetValue("ReqAnsLog", ReqAnsLog)) {
        resolvepath(ReqAnsLog, workDir);
        config.StartLoggingUnfiltered<TReqAnsLog>(ReqAnsLog);
    }

    if (directives.GetValue("MisspellLog", MisspellLog)) {
        resolvepath(MisspellLog, workDir);
        config.StartLoggingUnfiltered<TMisspellLog>(MisspellLog);
    }

    if (directives.GetValue("TvmClientLog", TvmClientLog)) {
        resolvepath(TvmClientLog, workDir);
        config.StartLoggingUnfiltered<TTvmLog>(TvmClientLog);
    }

    if (directives.GetValue("InfoLogName", InfoLogName)) {
        if (auto log = TLoggerOperator<TInfoLog>::Get()) {
            log->SetName(InfoLogName);
        }
    }

    if (directives.GetValue("ReqAnsLogName", ReqAnsLogName)) {
        if (auto log = TLoggerOperator<TReqAnsLog>::Get()) {
            log->SetName(ReqAnsLogName);
        }
    }
}
