#pragma once

#include "named_log.h"

class ICustomReportBuilder;
class ISearchContext;

namespace NSearchProxy {

namespace NLogging {

enum class EFactorsAggregationStrategy {
    Intersect = 0,
    Union,
};

struct TReqansLogResult {
    bool Error {false};
    bool Incosistency {false};
};

class TReqAnsLog: public TNamedSearchLog {
public:
    TReqAnsLog(const TString& logType, ELogPriority priority = LOG_MAX_PRIORITY, size_t queueLen = 0)
        : TNamedSearchLog(logType, priority, queueLen)
    {
        SetName("saas-reqans");
    }

    static TReqansLogResult Log(ui32 id, ISearchContext* searchContext, EFactorsAggregationStrategy logsAggregation);
    static void Log(ui32 id, const ICustomReportBuilder& report);
};

}
}
