#pragma once

#include "named_log.h"

#include <library/cpp/tvmauth/client/logger.h>
#include <library/cpp/logger/global/global.h>

namespace NSearchProxy::NLogging {

class TTvmLog: public TSearchLog {
public:
    TTvmLog(const TString& logType, ELogPriority priority = LOG_MAX_PRIORITY, size_t queueLen = 0)
        : TSearchLog(logType, priority, queueLen)
    {
    }

    static void Log(ELogPriority priority, const TString& msg) {
        if (TLoggerOperator<TTvmLog>::Usage()) {
            TLoggerOperator<TTvmLog>::Log()
                << NLoggingImpl::GetLocalTimeS() << '\t' << priority << '\t' << msg << Endl;
        }
    }
};

class TTicketParser2TvmLog: public NTvmAuth::ILogger {
public:
    void Log(int lvl, const TString& msg) override {
        TTvmLog::Log(static_cast<ELogPriority>(lvl), msg);
    }
};

}
