#pragma once

#include <saas/searchproxy/proxy_meta/rearrange/abstract/rearrange.h>
#include <kernel/querydata/saas/saas_request/trie.h>

namespace NProxyMeta {

    class TFakeRequestSender : public NQueryDataSaaS::IRequestSender {
    private:
        NQueryDataSaaS::TSaaSRequestRec::TRef& SaasRequestRecRef;
        TCgiParameters& Cgi;
    public:
        TFakeRequestSender(NQueryDataSaaS::TSaaSRequestRec::TRef& saasRequestRecRef, TCgiParameters& cgi);

        virtual void SendRequest(
            const TString& /*client*/,
            const NQueryDataSaaS::TSaasKey& saasKey,
            NQueryDataSaaS::TSaaSRequestRec::TRef requestContext,
            TStringBuf additionalCgiParams
        ) override final;
    };

    struct TQueryDataTrieRearrangeConfig {
        NQuerySearch::TSaaSServiceOpts ServiceOpts;
        TString MaxDocsStr = "100500";
        TQueryDataTrieRearrangeConfig(const TCustomRearrangeParams& params);
    };

    class TQueryDataTrieRearrange : public ICustomRearrange {
    public:
        TQueryDataTrieRearrange(const TQueryDataTrieRearrangeConfig& config);

        virtual TString GetName() const override;

        virtual bool DoFormCgiParameters(TCgiParameters& cgi) override;

        virtual void DoProcessReplies(TVector<NProxyMeta::TSourceReply>& replies, ICustomReportBuilder& builder,
            IReplyContext& context) const override;

    TString GetConfig() const; //Testing hook

    private:
        const TQueryDataTrieRearrangeConfig& Config;
        NQueryDataSaaS::TSaaSRequestRec::TRef SaasRequestRecRef;
    };
} // namespace NProxyMeta
