#include "replier.h"
#include "search.h"
#include "context.h"

TDuration NProxyMeta::TReplier::GetDefaultTimeout() const {
    return Searcher->GetConfig().GetGlobalTimeout();
}

NProxyMeta::TReplier::TReplier(IReplyContext::TPtr context, const NProxyMeta::TSearch* searcher)
    : ISearchReplier(context, &searcher->GetHttpStatusManagerConfig())
    , Searcher(searcher)
{}

void NProxyMeta::TReplier::DoSearchAndReply() {
    if (!Searcher->SearchContext(Context)) {
        TAnswerBuilder builder(*Context, nullptr, false, nullptr, Searcher->GetHttpStatusManagerConfig());
        builder.AnswerFail("cannot activate search");
    }
}

IThreadPool* NProxyMeta::TReplier::DoSelectHandler() {
    return Searcher->GetSendHandler();
}
