#pragma once

#include <saas/searchproxy/common/replier.h>

namespace NProxyMeta {

    const TString PROXY_TYPE_PROXY = "proxy";

    class TSearch;

    class TReplier
        : public ISearchReplier
        , public NSearchProxy::TCommonReplierFeatures
    {
    private:
        const NProxyMeta::TSearch* Searcher;
    protected:
        virtual TDuration GetDefaultTimeout() const override;

        virtual void OnRequestExpired(const int httpCode) override {
            NSearchProxy::TCommonReplierFeatures::OnRequestExpired(httpCode, PROXY_TYPE_PROXY, Context);
        }
        virtual void OnQueueFailure() override {
            NSearchProxy::TCommonReplierFeatures::OnQueueFailure(Context, HttpStatusConfig.UnavailableStatus);
        }
        virtual void OnAccessDenied(const NSaas::TNotAuthorizedInfo& auth) override {
            NSearchProxy::TCommonReplierFeatures::OnAccessDenied(auth, PROXY_TYPE_PROXY, Context);
        }

    public:
        TReplier(IReplyContext::TPtr context, const NProxyMeta::TSearch* searcher);

    private:
        virtual void DoSearchAndReply() override;
        virtual IThreadPool* DoSelectHandler() override;
    };
}
