#pragma once

#include "report.h"

#include <search/idl/meta.pb.h>

#include <library/cpp/eventlog/eventlog.h>

#include <util/generic/maybe.h>

namespace NProxyMeta {
    class TReplyGuard {
    public:
        TReplyGuard(TRTYMetaProtoReportConstructor& reportConstructor, HttpCodes& answeredHttpCode,
            const TSelfFlushLogFramePtr evLog, const bool addEventLogToReport
        );

        ~TReplyGuard() noexcept(false);

        void SetReplyCode(HttpCodes codeReply);
        void SetProxyReport(NMetaProtocol::TReport&& report);

    private:
        TRTYMetaProtoReportConstructor& ReportConstructor;
        HttpCodes& CodeReply;
        TMaybe<NMetaProtocol::TReport> ProxyReport;
        const TSelfFlushLogFramePtr EventLogFrame;
        bool AddEventLogToReport;
    };
}
