#pragma once

#include <search/grouping/foundstat.h>
#include <search/session/searcherprops.h>
#include <kernel/search_daemon_iface/relevance_type.h>
#include <kernel/search_daemon_iface/cntintrf.h>
#include <kernel/search_types/search_types.h>

#include <kernel/urlid/doc_handle.h>

#include <util/generic/vector.h>

class TCgiParameters;
struct TGroupingIndex;

typedef ui64 TRelevStatEx[NUM_PRIORITIES];

class ISearchReplyData {
public:
    struct TMainDocArchiveInfo {
        TString Url;
        TString UrlProperty;
        TDocHandle DocId;
        TRelevance Relevance;
        TString HeadLine;
        TString Title;
        TVector<TString> Passages;
    };

    struct TGroupingInfo {
        TRelevStatEx Stat = {0,0,0};
        ui32 GroupsCount = 0;
    };

    struct TFullReportInfo {
        TRelevStatEx Stat = {0,0,0};
    };

    struct TGroupInfo {
        TRelevStatEx Stat = {0,0,0};
        TRelevance Relevance = 0;
        ui32 DocsCount = 0;
        TString CategString;
    };

    struct TDocCategInfo {
        TVector<TCateg> Categs;
        TVector<TString> CategsNames;
    };

    struct TAttrsInfo {
        TVector<TString> Attrs;
        TVector<ui32> DocsCount;
    };

    struct TPagingInfo {
        ui64 FirstGroup = 0;
        ui64 LastGroup = 0;
    };


    virtual ~ISearchReplyData() {}
    virtual void FillArchiveInfo(int group, int doc, const TGroupingIndex& gi, bool passages, TMainDocArchiveInfo& info) const = 0;

    virtual void FillReportStat(TFullReportInfo& info) const = 0;
    virtual void FillGroupingInfo(const TGroupingIndex& gi, TGroupingInfo& info) const = 0;
    virtual void FillGroupInfo(int group, const TGroupingIndex& gi, TGroupInfo& info) const = 0;
    virtual void FillDocCategInfo(int group, int doc, const TGroupingIndex& gi, const TString& attrName, int docInCateg, TDocCategInfo& info) const = 0;
    virtual void FillIndexAttrsInfo(int group, int doc, const TGroupingIndex& gi, TAttrsInfo& info) const = 0;
    virtual void SerializeAttributes(int gnGroup, int nDoc, const TGroupingIndex& gi, TArrayRef<const char * const> attrNames, IAttributeWriter& writer, bool withSafe) const = 0;
    virtual TSearcherPropsRef GetSearchProperties() const = 0;
    virtual void FillErrors(TVector<TString>& errors) const = 0;
    virtual void FillPagingInfo(const TGroupingIndex& gi, const int groups, const long int requestedPage, TPagingInfo& paging) const = 0;
};
