#pragma once

#include <saas/searchproxy/report/abstract/reply_data.h>
#include <saas/library/report_builder/abstract.h>
#include <library/cpp/object_factory/object_factory.h>
#include <util/generic/buffer.h>

struct TGroupingIndex;

class IReportFormatter : public IAttributeWriter {
public:
    using TFactory = NObjectFactory::TParametrizedObjectFactory<IReportFormatter, TString, const TCgiParameters&>;
    using TPtr = TAtomicSharedPtr<IReportFormatter>;

    virtual ~IReportFormatter() {}

    virtual bool OnDocument(const ISearchReplyData::TMainDocArchiveInfo& info) = 0;
    virtual bool OnGrouping(const TGroupingIndex& gi, const ISearchReplyData::TGroupingInfo& info,
        const ISearchReplyData::TPagingInfo& pagingInfo, const int numGroups) = 0;

    virtual bool OnGroup(const ISearchReplyData::TGroupInfo& info) = 0;
    virtual void OnCateg(const ISearchReplyData::TDocCategInfo& info, const TString& attr, ui64 index) = 0;
    virtual void OnReportStat(const TRelevStatEx& stat) = 0;
    virtual void OnReportGroupingStat(const TGroupingIndex& /*info*/,
        int /*numGroups*/, int /*numDocs*/, const TString& /*currentCateg*/) {};
    virtual void OnSearchProperties(TSearcherPropsRef props) = 0;
    virtual void OnError(const TString& errorString) = 0;

    virtual void OnDocAttributesStart() {}
    virtual void OnDocAttribute(const TString& name, const TString& value ) = 0;
    virtual void OnDocAttributesEnd() {}

    virtual void OnRequestText(const TString& text) = 0;
    virtual void OnRequestPage(const long /*page*/) {};

    virtual TBuffer GetResult() const = 0;

    virtual void FillHeaders(IReportBuilderContext& context) const {
        Y_UNUSED(context);
    }

    // IAttributeWriter
    virtual void operator()(TStringBuf name, TStringBuf value) override final {
        OnDocAttribute(TString{name}, TString{value});
    }

    virtual void operator()(TStringBuf name, float value) override final {
        OnDocAttribute(TString{name}, ::ToString(value));
    }
};
