#include "hilighter.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/maybe.h>

Y_UNIT_TEST_SUITE(JsonReportFormatterHilighterTests) {

    void CheckHighlightEntry(const NJson::TJsonValue& entry, const TString& canonText, const TMaybe<TString>& priority = Nothing()) {
        UNIT_ASSERT(entry.IsMap());
        if (priority.Defined()) {
            UNIT_ASSERT_VALUES_EQUAL(entry.GetMap().size(), 2);
            UNIT_ASSERT_VALUES_EQUAL(entry["priority"], priority.GetRef());
        } else {
            UNIT_ASSERT_VALUES_EQUAL(entry.GetMap().size(), 1);
        }
        UNIT_ASSERT_VALUES_EQUAL(entry["text"], canonText);
    }

    Y_UNIT_TEST(TestNoHilight) {
        const auto item = THilighter::Highlight("No hilight");
        UNIT_ASSERT(item.IsArray());
        UNIT_ASSERT_VALUES_EQUAL(item.GetArray().size(), 1);
        CheckHighlightEntry(item[0], "No hilight");
    }

    Y_UNIT_TEST(TestAllHilight) {
        const auto item = THilighter::Highlight("Passage with \007(all\007) priority \007(highlight\007)");
        UNIT_ASSERT(item.IsArray());
        UNIT_ASSERT_VALUES_EQUAL(item.GetArray().size(), 4);
        CheckHighlightEntry(item[0], "Passage with ");
        CheckHighlightEntry(item[1], "all", TMaybe<TString>("all"));
        CheckHighlightEntry(item[2], " priority ");
        CheckHighlightEntry(item[3], "highlight", TMaybe<TString>("all"));
    }

    Y_UNIT_TEST(TestStrictHilight) {
        const auto item = THilighter::Highlight("Passage with \007[strict\007] priority \007[highlight\007]");
        UNIT_ASSERT(item.IsArray());
        UNIT_ASSERT_VALUES_EQUAL(item.GetArray().size(), 4);
        CheckHighlightEntry(item[0], "Passage with ");
        CheckHighlightEntry(item[1], "strict", TMaybe<TString>("strict"));
        CheckHighlightEntry(item[2], " priority ");
        CheckHighlightEntry(item[3], "highlight", TMaybe<TString>("strict"));
    }

    Y_UNIT_TEST(TestPhraseHilight) {
        const auto item = THilighter::Highlight("Passage with \007{phrase\007} priority \007{highlight\007}");
        UNIT_ASSERT(item.IsArray());
        UNIT_ASSERT_VALUES_EQUAL(item.GetArray().size(), 4);
        CheckHighlightEntry(item[0], "Passage with ");
        CheckHighlightEntry(item[1], "phrase", TMaybe<TString>("phrase"));
        CheckHighlightEntry(item[2], " priority ");
        CheckHighlightEntry(item[3], "highlight", TMaybe<TString>("phrase"));
    }

    Y_UNIT_TEST(TestBrokenHilight1) {
        const auto item = THilighter::Highlight("Passage with \007[broken hilight");
        UNIT_ASSERT(item.IsArray());
        UNIT_ASSERT_VALUES_EQUAL(item.GetArray().size(), 2);
        CheckHighlightEntry(item[0], "Passage with ");
        CheckHighlightEntry(item[1], "broken hilight", TMaybe<TString>("strict"));
    }

    Y_UNIT_TEST(TestBrokenHilight2) {
        const auto item = THilighter::Highlight("Passage with \007ibroken hilight");
        UNIT_ASSERT(item.IsArray());
        UNIT_ASSERT_VALUES_EQUAL(item.GetArray().size(), 1);
        CheckHighlightEntry(item[0], "Passage with \007ibroken hilight");
    }
}
