#pragma once
#include "formatter.h"

#include <library/cpp/cgiparam/cgiparam.h>
#include <util/stream/buffer.h>


class TMinimalFormatter : public IReportFormatter {
public:
    TMinimalFormatter(const TCgiParameters& cgi) {
        Gta = cgi.Get("gta", 0);
    }

    virtual bool OnDocument(const ISearchReplyData::TMainDocArchiveInfo& /*info*/) override {
        return Result.empty();
    }

    virtual void OnDocAttribute(const TString& name, const TString& value) override {
        if (!Result.empty() || name != Gta)
            return;

        Result = value;
    }

    virtual void OnRequestText(const TString& /*text*/) override {}

    virtual bool OnGrouping(const TGroupingIndex&, const ISearchReplyData::TGroupingInfo&, const ISearchReplyData::TPagingInfo&,
        const int) override
    {
        return Result.empty();
    }

    virtual bool OnGroup(const ISearchReplyData::TGroupInfo&) override {
        return Result.empty();
    }

    virtual void OnCateg(const ISearchReplyData::TDocCategInfo& , const TString& , ui64 ) override {}
    virtual void OnReportStat(const TRelevStatEx&) override {}
    virtual void OnSearchProperties(TSearcherPropsRef) override {}

    virtual void OnError(const TString& error) override {
        Result = error;
    }

    virtual TBuffer GetResult() const override {
        TBuffer buf;
        TBufferOutput out(buf);
        out << Result;
        return buf;
    }

private:
    TString Result;
    TString Gta;

    static TFactory::TRegistrator<TMinimalFormatter> Registrator;
};
