#pragma once

#include <saas/searchproxy/search_meta/cgi_corrector.h>
#include <saas/searchproxy/search_meta/misspelledcontext.h>
#include <saas/searchproxy/configs/serviceconfig.h>
#include <saas/searchproxy/common/cgi.h>

struct TCgiAwareSearchContext: TMisspelledSearchContext {
private:
    ICgiCorrectorPtr CgiCorrector;
    const TServiceConfig& ServiceConfig;
public:
    inline TCgiAwareSearchContext(const TMetaSearch& owner, ITemplateCorrectorPtr templateCorrector,
                                  IMisspellCorrectorPtr misspellCorrector, ICgiCorrectorPtr cgiCorrector,
                                  const TServiceConfig& serviceConfig)
                                  : TMisspelledSearchContext(owner, templateCorrector, misspellCorrector)
                                  , CgiCorrector(cgiCorrector)
                                  , ServiceConfig(serviceConfig)
    {}

    bool AllowPropertyToReport(const TMsString& /*attr*/, const TMsString& name) const override {
        if (name == "_JsonFactors") {
            return !(RP().GetRelevParam<TString>("no_output_factors", "0") == "1");
        }
        return true;
    }

    void SetCgiParamsForClient() override {
        TMisspelledSearchContext::SetCgiParamsForClient();
        if (CgiCorrector) {
            CgiCorrector->SetClientCgi(CgiParam, ClientCgiParams, RP());
        }
    }

    const TServiceConfig& GetServiceConfig() const {
        return ServiceConfig;
    }
};
