#pragma once

#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/datetime/base.h>
#include <util/system/defaults.h>

struct TCorrectionResult {
    TString Suggest;
    TString Fixed;
    TString SrcText;
    TString Rule;
    TString ServiceRespose;
    ui32 Code;
    ui32 Reliability;

    inline TCorrectionResult(ui32 code, const TString& suggest, const TString& srcText, const TString& fixed, ui32 reliability,
                             const TString& rule, const TString& serviceResponse)
                             : Suggest(suggest)
                             , Fixed(fixed)
                             , SrcText(srcText)
                             , Rule(rule)
                             , ServiceRespose(serviceResponse)
                             , Code(code)
                             , Reliability(reliability)
    {
    }
    inline TCorrectionResult()
        : Code(0)
        , Reliability(0)
    {
    }

    bool operator!() const {
        return Code == 0;
    }
};

struct IMisspellCorrector
    : public TAtomicRefCount<IMisspellCorrector>
    , TNonCopyable
{
    virtual ~IMisspellCorrector() {}
    virtual TCorrectionResult CorrectRequest(const TString& reqid, const TString& request) const = 0;
};

using IMisspellCorrectorPtr = TIntrusivePtr<IMisspellCorrector>;
