#pragma once

#include "misspellcorrector.h"
#include "sequentialsearch.h"
#include "template_corrector.h"

class TMisspellContext {
public:
    enum class EPolicy {
        Skip,
        Force,
        TryAtFirst,
        TrySkipAtFirst
    };
protected:
    enum class EStage {
        Original,
        Misspelled
    };

protected:
    TCorrectionResult Result;
    TString  OriginalText;
    bool    Initialized  = false;
    bool    DumpResponse = false;
    bool    Applied = false;
    EPolicy Policy  = EPolicy::Skip;
    EStage  Stage   = EStage::Original;
    ui32    MinRel  = 0;

protected:
    void Fill(const TCgiParameters& cgi);

    bool Enabled() const {
        return Policy != EPolicy::Skip;
    }
};

class TMisspelledSearchContext
    : public TSequentialSearchContext
    , public TMisspellContext
{
public:
    TMisspelledSearchContext(const TMetaSearch& owner, ITemplateCorrectorPtr templateCorrector, IMisspellCorrectorPtr misspellCorrector);

protected:
    // TSequentialSearchContext
    virtual bool ShouldContinue(int res, ISearchContext& sc);
    virtual void PrepareContext(ISearchContext& sc);

private:
    void SetText(const TString& text, TReqEnv* reqEnv);
    void DumpMisspellInfo();
    void FetchMisspellInfo(TReqEnv* reqEnv);

private:
    ITemplateCorrectorPtr TemplateCorrector;
    IMisspellCorrectorPtr   ErratumProvider;
};
