#pragma once

#include <search/report/builtin/base/base.h>

#include <kernel/search_daemon_iface/pagecb.h>
#include <kernel/reqerror/reqerror.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

struct IHttpStatusManager;
class ICgiCorrector;
class IPageCallback;
class IRequestContext;
class ISearchContext;
struct IMisspellCorrector;
class TExtendedSearchContext;
class TSearchRequestData;
class TServiceConfig;

class TServiceMetric;
typedef TAtomicSharedPtr<TServiceMetric> TServiceMetricPtr;

struct TSearchProxyPageCallback: TBaseBuiltinPageCallback {
public:
    const TServiceConfig& ServiceConfig;
    const IHttpStatusManager& HttpStatusManager;
    ICgiCorrector& CgiCorrector;
    TServiceMetricPtr Metric;
    bool SafeReport;

    TSearchProxyPageCallback(IPageCallback* backupCallback,
        const TServiceConfig& serviceConfig,
        const IHttpStatusManager& httpStatusManager,
        ICgiCorrector& cgiCorrector,
        TServiceMetricPtr metric
    );

    ~TSearchProxyPageCallback();

    int HTTPHead(IRequestContext* requestContext,
        ISearchContext* searchContext);
    void ParseRequest(ISearchContext* searchContext);
    int MakePage(IRequestContext* requestContext);
    int Report(ISearchContext* searchContext);
    int ReportSnippets(IPassageContext* passageContext,
        NSearch::IOutputContext* out, const TSearchRequestData& rd);

private:
    TInstant GetDeadline(const TExtendedSearchContext& searchContext) const;
    void CheckDeadline(TExtendedSearchContext& searchContext, TInstant deadline, bool critical) const;

    void PreSearchDbgCall(const TSearchRequestData& rd);
    void PostSearchDbgCall(const TSearchRequestData& rd);
};
