#pragma once

#include <search/meta/context.h>

class TMetaSearch;

class TSequentialSearchContext: public TMetaSearchContext {
public:
    TSequentialSearchContext(const TMetaSearch& owner);
    ~TSequentialSearchContext();

    virtual int LoadOrSearch() final;

protected:
    TMetaSearchContext* CreateSeqContext() const;

    virtual bool ShouldContinue(int res, ISearchContext& sc) = 0;
    virtual void PrepareContext(ISearchContext& sc) = 0;

public: // ISearchContext
    virtual const IIndexProperty* IndexProperty();
    virtual IReqParams*           ReqParams();
    virtual IReqResults*          ReqResults();
    virtual ICluster*             Cluster();
    virtual IReqEnv*              ReqEnv();

protected:
    TMetaSearchContext* CurrentContext;

    TVector<TMetaSearchContext*> SeqContexts;
    TCgiParameters OriginalCgiParameters;
    ui32 SearchCount;
    ui32 MaxSearchCount;
};
