#pragma once

#include <search/session/reqenv.h>

class TSearchServerConfig;

class ITemplateCorrector
    : public TAtomicRefCount<ITemplateCorrector>
    , TNonCopyable
{
public:
    virtual ~ITemplateCorrector() {}
    virtual TString FillTemplate(TReqEnv& reqEnv, const TString& text) = 0;
};

using ITemplateCorrectorPtr = TIntrusivePtr<ITemplateCorrector>;

ITemplateCorrectorPtr CreateTemplateCorrector(const TSearchServerConfig& config);
