#pragma once

#include <saas/library/unistat_signals/frame.h>

class TSaasProxyUnistatFrame: public TSaasUnistatFrame {
public:
    using TSaasUnistatFrame::TSaasUnistatFrame;

protected:
    virtual void OnSubSourceInit(const TString& subsource) override;
    virtual void OnSubSourceError(const TString& subsource) override;
    virtual void OnSubSourceOk(const TString& subsource, ui64 elapsedTimeMicroseconds, ui64 responseSize) override;
    virtual void OnSubSourceRequest(const TString& subsource, ui32 urlSize, ui64 bodySize) override;

    virtual void DoFinalize() override;

private:
    // from upper search
    THashMap<TString, bool> UsedSubsources_; // true == has subsource ok,
};
