#pragma once
#include <library/cpp/unistat/unistat.h>
#include <library/cpp/http/misc/httpcodes.h>
#include <util/string/cast.h>

#include <search/session/reqenv.h>

#include <saas/library/daemon_base/unistat_signals/signals.h>
#include <saas/library/searchserver/http_status_config.h>
#include <saas/searchproxy/configs/searchproxyconfig.h>
#include <saas/searchproxy/common/cgi.h>
#include <saas/searchproxy/logging/common.h>
#include <saas/searchproxy/search_meta/extendedcontext.h>
#include <saas/searchproxy/proxy_meta/rearrange/abstract/rearrange.h>

class TSaasSearchProxySignals : public TSaasProxyUnistatSignals {
public:
    TSaasSearchProxySignals();
    void Init(TUnistat& t) const;

    static void BuildSignals(const TSearchProxyConfig& config);
    static bool DoUnistatRecord(const TExtendedSearchContext& searchContext);
    static bool DoUnistatRecord(const TExtendedReplyContext& searchContext);
    static bool DoUnistatReqansLoggingError(const TString& service);
    static bool DoUnistatReqansLoggingIncosistency(const TString& service);
    static bool DoUnistatExceptionRecord(const TString& service);
    static bool DoUnistatUnavailable(const TString& service);
    static bool DoUnistatTvmException(const TString& service, const bool dryrun);
    static bool DoUnistatTvmNoTicket(const TString& service, const bool dryrun);
    static bool DoUnistatTvmBadTicket(const TString& service, const bool dryrun);
    static bool DoUnistatTvmAccessDenied(const TString& service, const bool dryrun);
    static bool DoUnistatTvmAccessGranted(const TString& service, const bool dryrun);
    static void PushCodeSignals(const int code, const TString& service, const TString& cache);
private:
    static void PushCodeSignal(const TString& code, const TString& service, const TString& cache);
    static void PushTvmCodeSignals(const TString& service, int code);
    static bool DoUnistatTvm(const TString& service, const bool dryrun, const TString& event);
    void HttpCodesToSignals(const THttpStatusManagerConfig& conf);
    void InitServiceSignals(TUnistat& t, TString service, const TVector<double>& intervals) const;

    TRearrangeSignals RearrangeSignals;
    THashMap<TString, THashSet<TString>> ServiceSubsources;
};
