#include "signals.h"

#include <saas/library/daemon_base/unistat_signals/signals_ut_helpers.h>

#include <library/cpp/testing/unittest/registar.h>

namespace {
    static const TString TestService("test_service_name");

    struct TMockSearchProxyConfig {
        TDaemonConfig DaemonConfig;
        TConfigPatcher ConfigPatcher;
        NSearchMapParser::TSearchMap SearchMap;
        THolder<TSearchProxyConfig> Config;
    public:
        TMockSearchProxyConfig()
            : DaemonConfig(TDaemonConfig::DefaultEmptyConfig.data(), false)
        {
            SearchMap.AddService(TestService);
            SearchMap.Compile(false, false);
            static const char* const text = "<SearchProxy>\nHost: localhost\nPort: 7777\n</SearchProxy>";
            Config = MakeHolder<TSearchProxyConfig>(text, DaemonConfig, SearchMap, ConfigPatcher);
        }
    };

    const TSearchProxyConfig& GetConfig() {
        static const TMockSearchProxyConfig proxyConfig;
        return *proxyConfig.Config;
    }
}

Y_UNIT_TEST_SUITE(RtyServerUnistatSignalsSuite) {
    Y_UNIT_TEST(TestInit) {
        ClearSignals();
        TSaasSearchProxySignals::BuildSignals(GetConfig());
        PrintSignals();
    }
    Y_UNIT_TEST(TestExceptionRecord) {
        ClearSignals();
        TSaasSearchProxySignals::BuildSignals(GetConfig());
        TSaasSearchProxySignals::DoUnistatExceptionRecord(TestService);
        PrintSignals();
    }
    Y_UNIT_TEST(TestUnavailable) {
        ClearSignals();
        TSaasSearchProxySignals::BuildSignals(GetConfig());
        TSaasSearchProxySignals::DoUnistatUnavailable(TestService);
        PrintSignals();
    }
    Y_UNIT_TEST(TestReqansLoggingIncosistency) {
        ClearSignals();
        TSaasSearchProxySignals::BuildSignals(GetConfig());
        TSaasSearchProxySignals::DoUnistatReqansLoggingIncosistency(TestService);
        PrintSignals();
    }
    Y_UNIT_TEST(TestReqansLoggingError) {
        ClearSignals();
        TSaasSearchProxySignals::BuildSignals(GetConfig());
        TSaasSearchProxySignals::DoUnistatReqansLoggingError(TestService);
        PrintSignals();
    }
    //TODO: test TSaasSearchProxySignals::DoUnistatRecord(const TExtendedSearchContext& searchContext)
    //TODO: test TSaasSearchProxySignals::DoUnistatRecord(const TExtendedReplyContext& searchContext)
}
