#include <saas/searchproxy/experiment/context.h>
#include <saas/searchproxy/experiment/ctx_creator.h>

#include <library/cpp/http/misc/httpreqdata.h>
#include <library/cpp/testing/unittest/registar.h>

#include <library/cpp/cgiparam/cgiparam.h>
#include <util/generic/vector.h>
#include <library/cpp/string_utils/quote/quote.h>

#include <search/request/data/reqdata.h>

TString MakeExperiment(TCgiParameters& cgi, const TSearchRequestData* rd = nullptr) {
    NSaas::NExperiments::TContextCreator ctxCreator;
    NSaas::NExperiments::TUserCtx ctx;
    ctx.Fill(cgi, rd ? *rd : TSearchRequestData());
    ctxCreator.Process(ctx, cgi);
    return ToString(ctx.Buckets);
}

Y_UNIT_TEST_SUITE(TSaasAbtExperimentTest) {
    Y_UNIT_TEST(UserSplit) {
        TCgiParameters cgi("&service=ya-store");
        TSearchRequestData rd;
        rd.AddHeader("X-Yandex-ExpConfigVersion", "123");
        rd.AddHeader("X-Yandex-ExpBoxes", "1,66,10");
        rd.AddHeader("X-Yandex-ExpFlags", "W3siSEFORExFUiI6IlNBQVMiLCJDT05URVhUIjp7IkdMT0JBTCI6eyJzb3VyY2UiOnsiZG9uYW5pbWhhYmVyIjp7InJlbGV2IjpbImF0dHJfbGltaXQ9OTk5OTkiXX19fSwiQTEiOnsic291cmNlIjp7ImRvbmFuaW1oYWJlciI6eyJyZWxldiI6WyJmb3JtdWxhPWRlZmF1bHQiXX19fSwiQjEiOnsic291cmNlIjp7ImRvbmFuaW1oYWJlciI6eyJyZWFyciI6WyJzY2hlbWVfTG9jYWwvQW50aUR1cC9FbmFibGVkPTAiXSwicmVsZXYiOlsiZm9ybXVsYT1ub2thcm1hIl19fX0sIlNBQVMiOnsiZmxhZ3MiOnsiMSI6WyJ0ZGkiXX19fSwiQ09ORElUSU9OIjoiZGVza3RvcCJ9XQ==");
        const TString triplet = MakeExperiment(cgi, &rd);

        UNIT_ASSERT_STRINGS_EQUAL(triplet.data(), "1,66,10");
    }
}
