#include "helpers.h"
#include <library/cpp/testing/unittest/registar.h>
#include <saas/searchproxy/rearrange/l3/l3.h>

class TEncodeFactorsIndicesTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TEncodeFactorsIndicesTest)
        UNIT_TEST(TestSimple)
    UNIT_TEST_SUITE_END();

    struct TTestCase {
        NRTYFactors::TUsedFactors Idxs;
        TString Expected;
    };

public:
    void TestSimple() {
        TVector <TTestCase> cases{
                {{1, 3,  5, 6, 10, 100, 101, 102, 103, 110}, "1,3,5-6,10,100-103,110"},
                {{5},                                        "5"},
                {{5, 10, 20},                                "5,10,20"},
                {{5, 6},                                     "5-6"},
                {{5, 6,  7},                                 "5-7"},
                {{1, 5,  6, 7},                              "1,5-7"},
                {{5, 6,  7, 9},                              "5-7,9"},
                {{1, 5,  6, 7, 9},                           "1,5-7,9"},
                {{1, 5,  6, 7, 9},                           "1,5-7,9"},
                {{1, 5,  6, 7, 9,  110, 111, 112, 333},      "1,5-7,9,110-112,333"},
                {{},                                         ""}
        };

        for (const auto &c : cases) {
            auto actual = NSaas::EncodeFactorsIndices(c.Idxs);
            UNIT_ASSERT_VALUES_EQUAL(actual, c.Expected);
        }
    }
};

UNIT_TEST_SUITE_REGISTRATION(TEncodeFactorsIndicesTest)
