#pragma once

namespace NSearchProxyTvmTest {
    enum class EServerAuthMode {
        Disabled,
        Enabled
    };

    enum class EServiceAuthMode {
        Disabled,
        DryRun,
        Enabled
    };

    enum class EProto {
        Http,
        Neh
    };

    enum class ETicketContainer {
        Header,
        Cgi
    };

    enum class EService {
        FullText,
        KeyValue
    };

    enum class EMeta {
        NotMeta,
        Meta
    };

    enum EMetaAuth {
        Disabled,
        AsOnBackend
    };

    enum class EServiceTicket {
        NoTicket,
        BadTicket,
        Allowed,
        Disallowed,
        Throw,
        TvmProxy,
        FlowMirrorAllowed,
    };

    enum class EUserTicket {
        NoTicket,
        BadTicket,
        Allowed,
        Disallowed,
        Throw
    };

    enum class EResult {
        Unknown,
        Unauthorized,
        Forbidden,
        Authorized,
        InternalServerError,
    };

    enum class EErrorSource {
        SearcherProp,
        ErrorInfo
    };

    enum class EForceAuth {
        DoNotForce,
        Force
    };

    enum class EFlowMirror {
        Disabled,
        Enabled
    };
};
