#pragma once

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/system/defaults.h>

class TBasicServer {
public:
    struct IImpl;

private:
    THolder<IImpl> Impl;

public:
    TBasicServer(IImpl* impl);
    ~TBasicServer();
    ui16 GetPort() const;
    template <class TImpl>
    TImpl* Ptr() const
    {
        return static_cast<TImpl*>(Impl.Get());
    }

    unsigned GetCallsCount() const;
    void Stop();
};

struct TSilentServer: TBasicServer {
    TSilentServer();
};

struct TStaticServer: TBasicServer {
    static const TString DefaultMime;

    TStaticServer(const TDuration& delay = TDuration());
    TStaticServer(ui16 port, const TDuration& delay = TDuration());
    // TString used here because of its sharedness,
    // so, immutable data will always stay on the same place
    bool AddDoc(const char* path, TString doc, TString mime = DefaultMime);
    void SetKV(const bool isKV = true);
};

