#pragma once

#include <library/cpp/object_factory/object_factory.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <library/cpp/json/writer/json_value.h>
#include <saas/library/indexer_protocol/abstract.h>

class TIndexerServer;
namespace NRTYServer {
    class TMessage;
}

class IExternalServiceLogic {
public:

    using TFactory = NObjectFactory::TParametrizedObjectFactory<IExternalServiceLogic, TString>;
    using TPtr = TAtomicSharedPtr<IExternalServiceLogic>;

    virtual ~IExternalServiceLogic() {}
    virtual void StartIndexation(TIndexerServer& server) = 0;
    virtual void FinishIndexation() = 0;
    virtual bool AddMessage(const NRTYServer::TMessage& message, IRTYReplierAbstract* replier) = 0;
    virtual TString GetInfo(const TString& key) const = 0;
    virtual NJson::TJsonValue ExternalControl(const TString& command) const = 0;
    virtual TString GetName() const = 0;
};
