#!/bin/bash

source _config.in.sh

echo "#!/bin/bash"
echo "# Generated as: source _fetch.in.sh > fetch.sh"
echo
echo "rm -r nanny/* 2>/dev/null"
echo "mkdir nanny 2>/dev/null"
echo "set -e"

for SERV in ${SERVICES[@]}; do
    >&2 echo
    if [ ${NOT_NANNY[$SERV]} ]; then
        >&2 echo "=== Will ignore $SERV : not in Nanny"
        continue
    fi

    >&2 echo "=== Scripting $SERV"
    echo ">&2 echo"
    echo ">&2 echo === Fetching $SERV"
    echo "mkdir nanny/$SERV"
    echo "get_nanny_file -b $SERV canon_configs nanny/$SERV/canon_configs || >&2 echo \"Warning: No canon_configs resource in $SERV\""
    for i in environment basesearch-refresh OxygenOptions.cfg OxygenOptionsRt.cfg rtyserver.conf; do 
        SS=${S[$SERV]};
        SUF_O=$(echo $SS | sed s:-none::);
        SUF_RTY=$(echo $SS | sed s:-none:-common:);
        SUF=$SUF_O; [[ $i == *"rtyserver"* ]] && SUF=$SUF_RTY;
        O=$(echo $i | sed 's:rtyserver.conf:rtyserver.conf-common:');

        echo "get_nanny_file -b $SERV ${i}$SUF nanny/$SERV/${i}$SUF || cp -v nanny/$SERV/canon_configs/${i}$SUF nanny/$SERV/${i}$SUF";
    done;
done
