import saas.tools.devops.refresh_configs as refresh_configs

import argparse
import os


services = [
    'saas_refresh_3day_base_frozen',
    'saas_refresh_3day_hamster_base',
    'saas_refresh_3day_hamster_base_isolated',
    'saas_refresh_3day_production_base_multilang',
    'saas_refresh_quick2_experiment_base',
    'saas_refresh_staging_base_base',
    'saas_refresh_staging_mercury_base',
    'saas_news_quick_production_base',
    'saas_news_quick_hamster_base',
    'saas_cloud_news_quick_prestable'
]

environments = [
    'common',
    'frozen',
    'isolated',
    'staging_base',
    'staging_mercury',
    'news_quick',
    'news_quick_prestable',
    'news_quick_frozen'
]


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-p', '--yconf-patcher', default='../../../../search/tools/config_patcher/config_patcher')
    parser.add_argument('-i', '--input', default='../')
    parser.add_argument('-o', '--output', default='generated')
    parser.add_argument('-e', '--environments', default=','.join(environments))
    parser.add_argument('--no-oxygen-rt', action='store_true')
    parser.add_argument('--nanny', default=','.join(services))
    parser.add_argument('--tmp-dir', default='__services_configs')

    args = parser.parse_args()

    if not os.path.exists(args.output):
        os.mkdir(args.output)

    generator = refresh_configs.Generator(
        yconf_patcher=args.yconf_patcher,
        input_dir=args.input,
        output_dir=args.output,
        environments=args.environments.split(','),
        create_oxygen_rt=not args.no_oxygen_rt
    )
    generator.run()

    checker = refresh_configs.Checker(args.nanny.split(','), args.output, args.tmp_dir)
    checker.print_changes()


if __name__ == '__main__':
    main()
