#!/bin/bash

source _config.in.sh

TMP_DIFF=`mktemp /tmp/refresh_configs_diff.XXXXXXXX`

for SERV in ${SERVICES[@]}; do
    if [ ${NOT_NANNY[$SERV]} ]; then continue; fi
 
    for i in environment basesearch-refresh OxygenOptions.cfg OxygenOptionsRt.cfg rtyserver.conf; do 
        SS=${S[$SERV]};
        SUF_O=$(echo $SS | sed s:-none::);
        SUF_RTY=$(echo $SS | sed s:-none:-common:);
        SUF=$SUF_O; [[ $i == *"rtyserver"* ]] && SUF=$SUF_RTY;

        git --no-pager diff "nanny/$SERV/${i}$SUF" "generated/$SERV/${i}$SUF" >> $TMP_DIFF;
    done;
done

view $TMP_DIFF

rm $TMP_DIFF
