# -*- coding: utf-8 -*-
import flask

from flask import request, render_template, current_app, send_from_directory


saas_abcd_api = flask.Blueprint('saas_abcd_api', __name__)
content_type = 'text/plain; charset=utf-8'

# REST API Description
# https://wiki.yandex-team.ru/resource-model/providers/providerifacespec/#httprestapiresursnojjmodeli

@saas_abcd_api.route('/api/v1/unitsEnsembles', methods=['GET'])
def listUnitsEnsembles():
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/unitsEnsemble/<unitsEnsembleId>', methods=['GET'])
def getUnitsEnsemble(unitsEnsembleId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/unitsEnsembles/<unitsEnsembleId>/units/<unitUd>', methods=['GET'])
def getUnit(unitsEnsembleId, unitUd):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers', methods=['GET'])
def listProviders():
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>', methods=['GET'])
def getProvider(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/_readOnly?readOnly=true', methods=['POST'])
def setProviderReadOnly(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resources', methods=['GET'])
def listResourcesByProvider(prodiverId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resources/<resourceId>', methods=['GET'])
def getResource(providerId, resourceId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/accountsSpaces', methods=['GET'])
def listAccountsSpacesByProvide(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/accountsSpaces/<accountsSpaceId>', methods=['GET'])
def getAccountsSpace(providerId, accountsSpaceId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/folders', methods=['GET'])
def listFolders():
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/folders/<folderId>', methods=['GET'])
def getFolder(folderId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/folders/<folderId>/quotas', methods=['GET'])
def listQuotasByFolder(folderId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/services/<serviceId>/folders', methods=['GET'])
def listFoldersByService(serviceId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/folders/<folderId>/providers/<providerId>/resources/<resourceId>/quota', methods=['GET'])
def getQuotaByFolderResource(folderId, providerId, resourceId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/resources', methods=['GET'])
def listResourcesByProvider2(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/accountsSpaces', methods=['GET'])
def listAccountsSpacesByProvider(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/resourceTypes', methods=['GET'])
def listResourceTypesByProvider(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/resourceTypes/<resourceTypeId>', methods=['GET'])
def getResourceType(providerId, resourceTypeId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/segmentations', methods=['GET'])
def listResourceSegmentationsByProvider(providerId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/segmentations/<segmentationId>/segments', methods=['GET'])
def listResourceSegmentsBySegmentation(providerId, segmentationId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/accountsSpaces/<accountsSpaceId>', methods=['GET'])
def getAccountsSpace2(providerId, accountSpaceId):
    return flask.Response([], status=200, content_type=content_type)


@saas_abcd_api.route('/api/v1/providers/<providerId>/resourcesDirectory/segmentations/<segmentationId>', methods=['GET'])
def getResourceSegmentation(providerId, segmentationId):
    return flask.Response([], status=200, content_type=content_type)


